unit MDIFrame;

interface

uses
	 SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus;

type
  TFrameForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    New1: TMenuItem;
    Open1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Window1: TMenuItem;
    Tile1: TMenuItem;
    Cascade1: TMenuItem;
    Arrangeicons1: TMenuItem;
    OpenFileDialog: TOpenDialog;
    procedure Exit1Click(Sender: TObject);
    procedure New1Click(Sender: TObject);
    procedure Tile1Click(Sender: TObject);
    procedure Cascade1Click(Sender: TObject);
    procedure Arrangeicons1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
  private
    { Private declarations }
{$IFDEF CLR}
		procedure InitializeControls;
{$ENDIF}
  public
    { Public declarations }
{$IFDEF CLR}
		constructor Create(AOwner: TComponent); override;
{$ENDIF}
  end;

var
  FrameForm: TFrameForm;

implementation

uses
	 MDIEdit;

procedure TFrameForm.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TFrameForm.New1Click(Sender: TObject);
begin
  TEditForm.Create(Self);
end;

procedure TFrameForm.Tile1Click(Sender: TObject);
begin
  Tile;
end;

procedure TFrameForm.Cascade1Click(Sender: TObject);
begin
  Cascade;
end;

procedure TFrameForm.Arrangeicons1Click(Sender: TObject);
begin
  ArrangeIcons;
end;

procedure TFrameForm.Open1Click(Sender: TObject);
begin
  if OpenFileDialog.Execute then
  with TEditForm.Create(Self) do
    Open(OpenFileDialog.FileName);
end;

{$IFDEF CLR}
constructor TFrameForm.Create(AOwner: TComponent);
begin
	inherited CreateNew(AOwner);
	InitializeControls;
end;
{$ENDIF}
{$IFDEF CLR}
procedure TFrameForm.InitializeControls;
begin
  // Initalizing all controls...
	MainMenu1:= TMainMenu.Create(Self);
	File1:= TMenuItem.Create(Self);
	New1:= TMenuItem.Create(Self);
	Open1:= TMenuItem.Create(Self);
	N1:= TMenuItem.Create(Self);
	Exit1:= TMenuItem.Create(Self);
	Window1:= TMenuItem.Create(Self);
	Tile1:= TMenuItem.Create(Self);
	Cascade1:= TMenuItem.Create(Self);
	Arrangeicons1:= TMenuItem.Create(Self);
	OpenFileDialog:= TOpenDialog.Create(Self);
	
	with MainMenu1 do
	begin
		Parent:= Self;
	end;
	
	with File1 do
	begin
		MainMenu1.Items.Add(File1);
		Caption:= '&File';
	end;
	
	with New1 do
	begin
		File1.Add(New1);
		Caption:= '&New';
		OnClick:= New1Click;
	end;
	
	with Open1 do
	begin
		File1.Add(Open1);
		Caption:= '&Open...';
		OnClick:= Open1Click;
	end;
	
	with N1 do
	begin
		File1.Add(N1);
		Caption:= '-';
	end;
	
	with Exit1 do
	begin
		File1.Add(Exit1);
		Caption:= 'E&xit';
		GroupIndex:= 9;
		OnClick:= Exit1Click;
	end;
	
	with Window1 do
	begin
		MainMenu1.Items.Add(Window1);
		Caption:= '&Window';
		GroupIndex:= 9;
	end;
	
	with Tile1 do
	begin
		Window1.Add(Tile1);
		Caption:= '&Tile';
		OnClick:= Tile1Click;
	end;
	
	with Cascade1 do
	begin
		Window1.Add(Cascade1);
		Caption:= '&Cascade';
		OnClick:= Cascade1Click;
	end;
	
	with Arrangeicons1 do
	begin
		Window1.Add(Arrangeicons1);
		Caption:= '&Arrange icons';
		OnClick:= Arrangeicons1Click;
	end;
	
	with OpenFileDialog do
	begin
		Parent:= Self;
		Filter:=  'Rich text files (*.rtf)|*.rtf|Plain text files (*.txt)|*.txt|All' +
		  ' files|*.*';
	end;

	// Form's PMEs'
	Left:= 875;
	Top:= 501;
	Width:= 435;
	Height:= 300;
	Caption:= 'Text editor';
	Color:= clBtnFace;
	Font.Charset:= DEFAULT_CHARSET;
	Font.Color:= clWindowText;
	Font.Height:= -11;
	Font.Name:= 'MS Sans Serif';
	Font.Style:= [];
	FormStyle:= fsMDIForm;
	Menu:= MainMenu1;
	Position:= poDefault;
	WindowMenu:= Window1;
end;
{$ENDIF}
end.
